/*
 *  file name: GuitarHeroLite.kt
 *
 *  Plays two guitar strings (concert A and concert C)
 *  when the user types the lowercase letters 'a' and 'c',
 *  respectively in the standard drawing window.
 *
 *  You need to compile this file and run the resulting class file
 *  together with 'stdlib.jar' because it uses the 'StdDraw' and
 *  'StdAudio' libraries from stdlib.
 */

import kotlin.math.pow

fun main(args: Array<String>) {
    // Create two guitar strings, for concert A and C
    val CONCERT_A = 440.0
    val CONCERT_C = CONCERT_A * 2.0.pow(3.0 / 12.0)
    val stringA = GuitarString(CONCERT_A)
    val stringC = GuitarString(CONCERT_C)

    // the main input loop
    while (true) {

        // check if the user has typed a key, and, if so, process it
        if (StdDraw.hasNextKeyTyped()) {

            // the user types this character
            val key = StdDraw.nextKeyTyped()

            // pluck the corresponding string
            if (key == 'a') stringA.pluck()
            if (key == 'c') stringC.pluck()
        }

        // compute the superposition of the samples
        val sample = stringA.sample() + stringC.sample()

        // send the result to the sound card
        StdAudio.play(sample)

        // advance the simulation of each guitar string by one step
        stringA.tic()
        stringC.tic()
    }
}
