/*
 * File: ifs.kt
 * Data: 2019-10-15
 * Author: SS
 */

/**
 * Use the Iterated Function Systems (IFSs) method to create fractals.
 */
import processing.core.*
import org.nield.kotlinstatistics.*

fun main(args: Array<String>) = PApplet.main("Ifs", args)

class Ifs : PApplet() {
    var trials = 0

    // probability distribution for choosing each rule
    lateinit var dist: Array<Pair<Int,Double>>

    // update matrices
    lateinit var cx: Array<FloatArray>
    lateinit var cy: Array<FloatArray>

    // current value of point (x, y) in Cartesian system
    var x = 0F
    var y = 0F

    override fun settings() {
        trials = args[0].toInt()
        java.util.Scanner(java.io.FileReader(args[1])).use { sc ->

            // Reads a 1D array of Doubles from input file and turn each Double value
            // into a pair (index to value), and put it in dist.
            dist = Array<Pair<Int,Double>>(sc.nextInt()) { it to sc.nextDouble() }

            // Reads the update matrix for x-coordinate from input file.
            var row = sc.nextInt()
            var col = sc.nextInt()
            cx = Array<FloatArray>(row) {
                    FloatArray(col) {
                        sc.nextFloat()
                    }
            }

            // Reads the update matrix for y-coordinate from input file.
            row = sc.nextInt()
            col = sc.nextInt()
            cy = Array<FloatArray>(row) {
                    FloatArray(col) {
                        sc.nextFloat()
                    }
            }
        }

        //size(740, 740)
        fullScreen()
        noLoop()
    }

    override fun draw() {
        stroke(0F, 160F, 0F) // green
        repeat(trials) {
            val dice = WeightedDice(*dist)
            val r = dice.roll()
            // do the update
            val x0 = cx[r][0]*x + cx[r][1]*y + cx[r][2]
            val y0 = cy[r][0]*x + cy[r][1]*y + cy[r][2]
            x = x0
            y = y0
            point(transformX(x), transformY(y))
        }
    }

    private fun transformX(x: Float): Float =
        map(x, -0.5F, 1.5F, 0F, width.toFloat())

    private fun transformY(y: Float): Float =
        map(y, -0.5F, 1.5F, height.toFloat(), 0F)
}
