/**
 * file: RandomFigures.kt
 * date: Sep 26, 2023
 *
 * @author: San Skulrattanakulchai
 */

import processing.core.PApplet

const val HOW_MANY_FIGURES = 50

fun main() {
    PApplet.main("RandomRectsCirclesSketch")
}

class RandomRectsCirclesSketch : PApplet() {
    override fun settings() {
        size(400, 400)
    }

    override fun setup() {
        rectMode(CENTER)
        noLoop()
    }

    override fun draw() {
        repeat(HOW_MANY_FIGURES) {
            val x = random(1F, width.toFloat())
            val y = random(1F, height.toFloat())
            fill(random(256F), random(256F), random(256F))
            if (random(2F) < 1F) {
                val size = random(10F, 60F)
                ellipse(x, y, size, size)
            } else {
                val w = random(10F, 60F)
                val h = random(10F, 60F)
                rect(x, y, w, h)
            }
        }
    }
}
